/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_drm_client.h
 * $Revision: 1.1 $
 *----------------------------------------------------------------------------
 * Copyright 2003  2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *----------------------------------------------------------------------------
 * Functions:
 * 
 * 
 *----------------------------------------------------------------------------
 */

#ifndef __IEGD_DRM_CLIENT_H__
#define __IEGD_DRM_CLIENT_H__
typedef struct drm_intel_getpages {
	int size;
	unsigned long phy_address;
	unsigned long virt_address;
	unsigned long offset;
} drm_intel_getpages_t;

typedef struct drm_intel_freepages {
	int size;
	unsigned long phy_address;
	unsigned long virt_address;
	unsigned long offset;
} drm_intel_freepages_t;


/*
 * This is the basic information structure that is is obtained from the
 * IEGD drm driver.
 */
typedef struct _intel_drm_info {
	unsigned long device_id;
	unsigned long revision;
	unsigned long video_memory_offset;
	unsigned long video_memory_size;
	unsigned long hw_status_offset;
} intel_drm_info_t;

#define DRM_IOCTL_BASE			'd'
#define DRM_IO(nr)			_IO(DRM_IOCTL_BASE,nr)
#define DRM_IOR(nr,type)		_IOR(DRM_IOCTL_BASE,nr,type)
#define DRM_IOW(nr,type)		_IOW(DRM_IOCTL_BASE,nr,type)
#define DRM_IOWR(nr,type)		_IOWR(DRM_IOCTL_BASE,nr,type)

/* IOCTL numbers to be used along side drmCommand* in Xserver 
 * example taken from intel_dri.c:  
 *	drmCommandWrite(iptr->drm_sub_fd
 *		, DRM_INTEL_INFO_INIT
 *		, &info,sizeof(intel_drm_info_t)
 */

#define DRM_BASE_COMMAND                0x40
#define DRM_INTEL_GETPAGES              0x01
#define DRM_INTEL_FREEPAGES             0x02
#define DRM_INTEL_INFO_INIT             0x03
#define DRM_INTEL_INFO_GET              0x04

#define DRM_IOCTL_INTEL_GETPAGES         DRM_IOWR(DRM_BASE_COMMAND + \
				DRM_INTEL_GETPAGES, drm_intel_getpages_t)
#define DRM_IOCTL_INTEL_FREEPAGES         DRM_IOWR(DRM_BASE_COMMAND + \
				DRM_INTEL_FREEPAGES, drm_intel_freepages_t)
#define DRM_IOCTL_INTEL_INFO_INIT		DRM_IOW( DRM_BASE_COMMAND + \
				DRM_INTEL_INFO_INIT, intel_drm_info_t)
#define DRM_IOCTL_INTEL_INFO_GET		DRM_IOR( DRM_BASE_COMMAND + \
				DRM_INTEL_INFO_GET, intel_drm_info_t)

#endif
