#ifndef	__ERRCODE_H_
#define	__ERRCODE_H_


#ifdef	__cplusplus
extern "C" {
#endif	

  /*	 Error Code                                                        
   *	 Error Code Formate (unsigned int)                                       
   *       0xMMmmSSRR                                                        
   *       MM : Main Error Codes for APIs (0~255)                            
   *       mm : Main Error Codes for Device Return (Refer to bellow table)   
   *       SS : Sub Error Codes for General error (0~255)                    
   *       RR : Reserved                                                     
   */

#define ERROR_API_SUCC			    0x00000000
#define ERRMSG(main,sub)	        (main|sub)

  //Error Code Masks
#define ERROR_MASK_GEN			    0x0000FF00
#define ERROR_MASK_API			    0xFF000000

  // Error Code Shift
#define ERROR_MASK_GEN_SHIFT		8
#define ERROR_MASK_API_SHIFT		24

#define ERRMSG_GEN(msg)			((msg<<ERROR_MASK_GEN_SHIFT)&ERROR_MASK_GEN)
#define ERRMSG_API(msg)			((msg<<ERROR_MASK_API_SHIFT)&ERROR_MASK_API)

  // Sub Error Codes for General error
#define ERROR_GEN_DRIVER_OPEN						ERRMSG_GEN(0x0F)    // Open Driver Error
#define ERROR_GEN_DEVICE_FAIL						ERRMSG_GEN(0x10)    // Read Writer Device Error
#define ERROR_GEN_INPUT_DATA						ERRMSG_GEN(0x11)	// Input Data Error
#define ERROR_GEN_DEVICE_OPEN		  				ERRMSG_GEN(0x0C)	// CAN device open error

  // Main Error Codes for APIs
#define ERROR_API_RELEASECARD		                ERRMSG_API(0x02)	// ERROR CODE FOR API RELEASECARD
#define ERROR_API_CANSENDMESSAGES				ERRMSG_API(0xC0)
#define ERROR_API_CANGETMESSAGES				ERRMSG_API(0xC1)
#define ERROR_API_CANCONFIG			ERRMSG_API(0xC2)
#define ERROR_API_REGISTERCARD		                ERRMSG_API(0x01)	// ERROR CODE FOR API REGISTERCARD

#ifdef	__cplusplus
}
	
#endif
#endif	 

