#ifndef __AGC_LIB_H_
#define __AGC_LIB_H_

#include <fcntl.h>
#include <sys/ioctl.h>

#ifdef	__cplusplus
extern "C" {
#endif	//__cplusplus 



typedef struct {
    /** flags, indicating or controlling special message properties */
    int             flags;
    int             cob;	 /**< CAN object number, used in Full CAN  */
    unsigned   long id;		 /**< CAN message ID, 4 bytes  */
    struct timeval  timestamp;	 /**< time stamp for received messages */
    short      int  length;	 /**< number of bytes in the CAN message */
    unsigned   char data[8]; /**< data, 0...8 bytes */
} canmsg_t;

struct Command_par {
  int cmd;			/**< special driver command */
  int target;			/**< special configuration target */
  unsigned long val1;		/**< 1. parameter for the target */
  unsigned long val2;		/**< 2. parameter for the target */
  int error;	 		/**< return value */
  unsigned long retval;	/**< return value */
};

/**
IOCTL Command request parameter structure */
typedef struct Command_par Command_par_t ; /**< Command parameter struct */
/**
IOCTL CConfiguration request parameter structure */
typedef struct Command_par  Config_par_t ; /**< Configuration parameter struct */

#define CAN_MSG_LENGTH 8                /**< maximum length of a CAN frame */
#define MSG_ACTIVE      (0)             /**< Controller Error Active */
#define MSG_BASE        (0)             /**< Base Frame Format */
#define MSG_RTR         (1<<0)          /**< RTR Message */
#define MSG_OVR         (1<<1)          /**< CAN controller Msg overflow error */
#define MSG_EXT         (1<<2)          /**< extended message format */
#define MSG_SELF        (1<<3)          /**< message received from own tx */
#define MSG_PASSIVE     (1<<4)          /**< controller in error passive */
#define MSG_BUSOFF      (1<<5)          /**< controller Bus Off  */
#define MSG_WARNING     (1<<6)          /**< CAN Warning Level reached */
#define MSG_BOVR        (1<<7)          /**< receive/transmit buffer overflow */


//###########################################################################
//# AGC Linux API Defines                                                   #
//###########################################################################
#define MAX_DEV	1

#define TRUE 1
#define FALSE 0

#define MAX_PORT_NUM PORT_NUM_L

#define MEMBASE    0x10
#define IOBASE     0x14

typedef unsigned char 	u8;
typedef int 	i32;
typedef char	i8;
typedef short 	i16;
typedef unsigned short u16;
typedef unsigned int u32;

#define ARBIOC_MAGIC  'k' /* Use 'k' as magic number */
#define ARBIOC_IOR_BYTE _IOR(ARBIOC_MAGIC,  0, unsigned int)
#define ARBIOC_IOR_WORD _IOR(ARBIOC_MAGIC,  1, unsigned int)
#define ARBIOC_IOR_DWRD _IOR(ARBIOC_MAGIC,  2, unsigned int)
#define ARBIOC_IOW_BYTE _IOW(ARBIOC_MAGIC,  3, unsigned int)
#define ARBIOC_IOW_WORD _IOW(ARBIOC_MAGIC,  4, unsigned int)
#define ARBIOC_IOW_DWRD _IOW(ARBIOC_MAGIC,  5, unsigned int)
#define ARBIOC_MMR_BYTE _IOR(ARBIOC_MAGIC,  6, unsigned int)
#define ARBIOC_MMR_WORD _IOR(ARBIOC_MAGIC,  7, unsigned int)
#define ARBIOC_MMR_DWRD _IOR(ARBIOC_MAGIC,  8, unsigned int)
#define ARBIOC_MMW_BYTE _IOW(ARBIOC_MAGIC,  9, unsigned int)
#define ARBIOC_MMW_WORD _IOW(ARBIOC_MAGIC,  10, unsigned int)
#define ARBIOC_MMW_DWRD _IOW(ARBIOC_MAGIC,  11, unsigned int)

#define ARBIOC_CFR_BYTE  _IOR(ARBIOC_MAGIC, 12, unsigned int)
#define ARBIOC_CFR_WORD  _IOR(ARBIOC_MAGIC, 13, unsigned int)
#define ARBIOC_CFR_DWRD  _IOR(ARBIOC_MAGIC, 14, unsigned int)
#define ARBIOC_CFW_BYTE  _IOW(ARBIOC_MAGIC, 15, unsigned int)
#define ARBIOC_CFW_WORD  _IOW(ARBIOC_MAGIC, 16, unsigned int)
#define ARBIOC_CFW_DWRD  _IOW(ARBIOC_MAGIC, 17, unsigned int)
#define ARBIOC_GET_CONT  _IOR(ARBIOC_MAGIC, 18, unsigned int)
#define ARBIOC_GET_BUFF  _IOR(ARBIOC_MAGIC, 19, unsigned int)

#define ARBIOC_CAN_COMMAND _IOR(ARBIOC_MAGIC, 20, unsigned int)
#define ARBIOC_CAN_CONFIG  _IOR(ARBIOC_MAGIC, 21, unsigned int)
#define ARBIOC_CAN_SEND    _IOR(ARBIOC_MAGIC, 22, unsigned int)
#define ARBIOC_CAN_STATUS  _IOR(ARBIOC_MAGIC, 23, unsigned int)

struct IO_ACCESS {
  unsigned long offset;
  union {
    unsigned char  byte;
    unsigned short word;
    unsigned int   dword;
    } value;
};

typedef struct _event {
  u16 Type;     //Event Type
  u16 Channel;   //Related Channel/Timer Number
  u16 Value;    //Related Value
} event;
#define INPUT_NO   12
#define OUTPUT_NO  12
#define TIMER_NO   16
#define INPUT       0x00
#define COUNTER_TO  0x01
#define COUNTER_OF  0x02
#define PG_FIN      0x03
#define TIMER_FIN   0x04
#define COUNTER_REACH 0x05
typedef void (*agc_callback_t) (event buf_context);

//###########################################################################
//# AGC Linux API Functions                                                 #
//###########################################################################
unsigned int LNX_RegisterCard(i16 *CardNum);
unsigned int LNX_ReleaseCard(i16 CardNum);
unsigned int LNX_GetMemBaseAddr(i16 CardNum, u32* MemBaseAddr);
unsigned int LNX_GetIOBaseAddr(i16 CardNum, u32* IOBaseAddr);

unsigned int LNX_ReadMemByte(i16 CardNum, u32 Offset, u8* Buffer);
unsigned int LNX_ReadMemWord(i16 CardNum, u32 Offset, u16* Buffer);
unsigned int LNX_ReadMemDWord(i16 CardNum, u32 Offset, u32* Buffer);
unsigned int LNX_WriteMemByte(i16 CardNum, u32 Offset, u8 Value);
unsigned int LNX_WriteMemWord(i16 CardNum, u32 Offset, u16 Value);
unsigned int LNX_WriteMemDWord(i16 CardNum, u32 Offset, u32 Value);
unsigned int LNX_SwitchMemMode(i16 CardNum, i16 Mode);
unsigned int LNX_ReadMemBlock(i16 CardNum, u32 Offset, u8* Buffer, u32 Size);
unsigned int LNX_WriteMemBlock(i16 CardNum, u32 Offset, u8* Buffer, u32 Size);

unsigned int LNX_ReadInputChannel(i16 CardNum, i16 ChannelNum, u8* Value);
unsigned int LNX_SetInputMode(i16 CardNum, i16 ChannelNum, u8 Mode);
unsigned int LNX_GetInputMode(i16 CardNum, i16 ChannelNum, u8* Mode);
unsigned int LNX_SetDebounce(i16 CardNum, i16 ChannelNum, u8 Dtime);
unsigned int LNX_GetDebounce(i16 CardNum, i16 ChannelNum, u8* Dtime);
unsigned int LNX_SetInputInterruptEnable(i16 CardNum, i16 ChannelNum, u8 Enable);
unsigned int LNX_GetInputInterruptEnable(i16 CardNum, i16 ChannelNum, u8* Enable);
unsigned int LNX_SetCounterTriggerType(i16 CardNum, i16 ChannelNum, u8 Type);
unsigned int LNX_GetCounterTriggerType(i16 CardNum, i16 ChannelNum, u8* Type);
unsigned int LNX_SetCounterMode(i16 CardNum, i16 ChannelNum, u8 Mode);
unsigned int LNX_GetCounterMode(i16 CardNum, i16 ChannelNum, u8* Mode);
unsigned int LNX_SetCounterTimeout(i16 CardNum, i16 ChannelNum, u16 Value);
unsigned int LNX_GetCounterTimeout(i16 CardNum, i16 ChannelNum, u16* Value);
unsigned int LNX_SetCounterTimeoutBase(i16 CardNum, i16 ChannelNum, u8 Base);
unsigned int LNX_GetCounterTimeoutBase(i16 CardNum, i16 ChannelNum, u8* Base);
unsigned int LNX_GetCounterValue(i16 CardNum, i16 ChannelNum, u16* Value);
unsigned int LNX_SetCounterTarget (i16 CardNum, i16 ChannelNum, u16 Value);
unsigned int LNX_GetCounterTarget (i16 CardNum, i16 ChannelNum, u16* Target);

unsigned int LNX_WriteOutputChannel(i16 CardNum, i16 ChannelNum, u8 Value);
unsigned int LNX_ReadOutputChannel(i16 CardNum, i16 ChannelNum, u8* Value);
unsigned int LNX_SetOutputMode(i16 CardNum, i16 ChannelNum, u8 Mode);
unsigned int LNX_GetOutputMode(i16 CardNum, i16 ChannelNum, u8* Mode);
unsigned int LNX_SetPGState(i16 CardNum, i16 ChannelNum, u8 State);
unsigned int LNX_GetPGState(i16 CardNum, i16 ChannelNum, u8* State);
unsigned int LNX_SetPGInterruptEnable(i16 CardNum, i16 ChannelNum, u8 Enable);
unsigned int LNX_GetPGInterruptEnable(i16 CardNum, i16 ChannelNum, u8* Enable);
unsigned int LNX_SetPGBase(i16 CardNum, i16 ChannelNum, u8 Base);
unsigned int LNX_GetPGBase(i16 CardNum, i16 ChannelNum, u8* Base);
unsigned int LNX_SetPGDuty(i16 CardNum, i16 ChannelNum, u8 High, u8 Low);
unsigned int LNX_GetPGDuty(i16 CardNum, i16 ChannelNum, u8* High, u8* Low);
unsigned int LNX_SetPGCycle (i16 CardNum, i16 ChannelNum, u16 Cycle);
unsigned int LNX_GetPGCycle (i16 CardNum, i16 ChannelNum, u16* Cycle);

unsigned int LNX_SetTimerInterruptEnable (i16 CardNum, i16 TimerNum, u8 Enable);
unsigned int LNX_GetTimerInterruptEnable (i16 CardNum, i16 TimerNum, u8* Enable);
unsigned int LNX_SetTimerBase (i16 CardNum, i16 TimerNum, u8 Base);
unsigned int LNX_GetTimerBase (i16 CardNum, i16 TimerNum, u8* Base);
unsigned int LNX_SetTimerValue (i16 CardNum, i16 TimerNum, u16 Value);
unsigned int LNX_GetTimerValue (i16 CardNum, i16 TimerNum, u16* Value);

unsigned int LNX_SetPG(i16 CardNum, i16 ChannelNum, u8 Base, u8 High, u8 Low, u16 Cycle);
unsigned int LNX_GetEventBuffer(i16 CardNum, event* Event);
unsigned int LNX_SetCallbackFunc(i16 CardNum , agc_callback_t func);
unsigned int LNX_GetEventCounter(i16 CardNum , u16* Count);

unsigned int LNX_CanSendMessages(i16 CardNum, canmsg_t* Buffer, u8 Count);
unsigned int LNX_CanGetMessages(i16 CardNum, canmsg_t* Buffer, u8 Count);
unsigned int LNX_CanConfig(i16 CardNum, i32 Baud);

#ifdef	__cplusplus
}
#endif	//__cplusplus 

#endif	// __AGC_LIB_H_
